//Copyright (C)2002 Peter Mertens <peter@pmertens.de>.  
package de.pmertens;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.InputStreamReader;
import java.io.FileWriter;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;
import org.w3c.dom.Attr;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXException;

import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;

//Klasse Kampagne liest und verarbeitet XML-Dokument zur Kampagnensteuerung
//unter Einsatz von DOM.
public class DOMKampagne implements ErrorHandler {
    
    //Konstruktormethoden
    public DOMKampagne () {
    }
    
    //Klassenmethoden warning, error und fatalError implementieren 
    //Interface Errorhandler
    public void warning(SAXParseException ex) {
        System.err.println("Warning in "+ ex.getSystemId() +
            " at line " + ex.getLineNumber() + 
            " column " + ex.getColumnNumber() +
            " : " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("Error in "+ ex.getSystemId() +
            " at line " + ex.getLineNumber() + 
            " column " + ex.getColumnNumber() +
            " : " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("Fatal Error in "+ ex.getSystemId() +
            " at line " + ex.getLineNumber() + 
            " column " + ex.getColumnNumber() +
            " : " + ex.getMessage());
    }
    
    //Instanzmethode parst XML-Dokument uri mittels DOM.
    public void DOMStart(String uri, boolean setvalidation, boolean setnamespaces, boolean setschema,
        boolean setschemafullchecking, boolean setdynamic, boolean setcontinueafterfatalerror,
        boolean setdefernodeexpansion, boolean dokumentaktualisieren, boolean zusaetzlicheElemente) {
        
        Datum stichtag= new Datum();
        
        try {
            //Instanz einer DOM Parser Implementation
            DOMParser domxmlparser = new DOMParser();
            
            domxmlparser.setFeature( "http://xml.org/sax/features/validation", 
                               setvalidation );
            domxmlparser.setFeature( "http://xml.org/sax/features/namespaces",
                               setnamespaces );
            domxmlparser.setFeature( "http://apache.org/xml/features/validation/schema",
                               setschema );
            domxmlparser.setFeature( "http://apache.org/xml/features/validation/schema-full-checking",
                               setschemafullchecking );
            domxmlparser.setFeature( "http://apache.org/xml/features/validation/dynamic",
                               setdynamic );
            domxmlparser.setFeature( "http://apache.org/xml/features/continue-after-fatal-error",
                               setcontinueafterfatalerror ); 
            domxmlparser.setFeature( "http://apache.org/xml/features/dom/defer-node-expansion",
                               setdefernodeexpansion ); 
            
            //Verknfung der Exceptionmethoden mit Parser-Instanz
            domxmlparser.setErrorHandler(this);
            
            //XML-Parsen des gesamten mittels URI angebenen Dokumentes
            domxmlparser.parse(uri);
            
            //instanzieren des XML-Dokumentes
            Document domdoc = domxmlparser.getDocument();
            //XMLAusgabe(domdoc );
            
            NodeList nodes = domdoc.getElementsByTagName("Stichtag");
            if (0 < nodes.getLength()) {
                Node node = nodes.item(0).getFirstChild();
                stichtag.setdatum(node.getNodeValue() );
            }
            
            //zur Historisierung sollen maximal 5 alte Stichtag-Elemente gespeichert werden
            //ltere Elemente werden gelscht
            Node parentnode= nodes.item(0).getParentNode();
            while (5< nodes.getLength() ) {
                parentnode.removeChild(nodes.item(5) );
            }
            
            //neues Element Stichtag mit aktuellem Datum als erstes Element einfgen
            Element stichelem= domdoc.createElement("Stichtag");
            stichelem.appendChild( domdoc.createTextNode(stichtag.getaktuellesDatum() ) );
            parentnode.insertBefore(stichelem, nodes.item(0) );
            
            System.out.print("Kampagne wurde letztmalig am "
                + stichtag.getdatum() + " gestartet. ");
            System.out.println("Das aktuelle Datum ist "
                + stichtag.getaktuellesDatum() + " .");
            System.out.println();
            
            nodes= domdoc.getElementsByTagName("Person");
            for (int i=0; i<nodes.getLength(); i++) 
                Anlassgenerierung(nodes.item(i), stichtag);
               
            //zustzliche Personendaten erfassen
            Node domroot = domdoc.getDocumentElement();
            if (zusaetzlicheElemente)
                erfasseElemente( domdoc, domroot );
            
            //XML-Document in Datei abspeichern
            if (dokumentaktualisieren)
                speicherDocument( domdoc, uri);
            
        } catch (org.xml.sax.SAXParseException spe) {
        } catch (org.xml.sax.SAXNotRecognizedException ex ){
        } catch (org.xml.sax.SAXNotSupportedException ex ){
        } catch (org.xml.sax.SAXException se) {
            if (se.getException() != null)
                se.getException().printStackTrace(System.err);
            else
                se.printStackTrace(System.err);
        } catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    //Klassenmethode verarbeitet Element Person:
    //Inhalte aller Kindelemente werden eingelesen und auf deren Basis
    //Anlsse generiert
    public void Anlassgenerierung(Node person, Datum stichtag)  {
        //Variablen fr Elementinhalte von Element Person
        String elementname= "";
        String elementinhalt= "";
        String nachname= "";
        String vorname= "";
        Datum geburts= new Datum();
        Datum hochzeits= new Datum();
        String geschlecht= "";
        String anrede= "";
        String kundenart= "";
        String familienstand= "";
        String postleitzahl= "";
        String ort= "";
        String strasse= "";
        
        Integer gebjahr, aktjahr;
        int alter;
        
        // Rekursiv alle Kindelemente vom Element Person lesen
        NodeList kindelemente = person.getChildNodes();
        if (kindelemente != null) {
            for (int i=0; i<kindelemente.getLength(); i++) {
                //nur Knoten vom Typ ELEMENT_NODE weiterverarbeiten,
                //brige bergehen
                if (kindelemente.item(i).getNodeType() == Node.ELEMENT_NODE) {
                    elementname = kindelemente.item(i).getNodeName();
                                
                    //Elementinhalt lesen
                    NodeList inhalt = kindelemente.item(i).getChildNodes();
                    //Nodelist inhalt enthlt nur ein Element vom Typ
                    //Node.TEXT_NODE oder Node.CDATA_SECTION_NODE,
                    //da keine Kindknoten entspr. DTD vorhanden
                    elementinhalt= inhalt.item(0).getNodeValue();
           
                    if (0 == elementname.compareTo("Nachname"))
                        nachname= elementinhalt;
                    if (0 == elementname.compareTo("Vorname"))
                        vorname= elementinhalt;
                    if (0 == elementname.compareTo("Geburtsdatum"))
                        geburts= new Datum(elementinhalt);
                    if (0 == elementname.compareTo("Hochzeitsdatum"))
                        hochzeits= new Datum(elementinhalt);
                    if (0 == elementname.compareTo("Geschlecht")) {
                        geschlecht= elementinhalt;
                        if (0 == geschlecht.compareTo("m"))
                            anrede= "Herr";
                        else
                            anrede= "Frau";
                    }
                    if (0 == elementname.compareTo("Kundenart"))
                        kundenart= elementinhalt;
                    if (0 == elementname.compareTo("Familienstand"))
                        familienstand= elementinhalt;
                    if (0 == elementname.compareTo("Postleitzahl"))
                        postleitzahl= elementinhalt;
                    if (0 == elementname.compareTo("Ort"))
                        ort= elementinhalt;
                    if (0 == elementname.compareTo("Strasse"))
                        strasse= elementinhalt;
                }
            }
        }
        
        //Prfung, ob Anlass fr eingelesenes Element vorliegt
        String jahr= geburts.getdatum();
        gebjahr= new Integer(jahr.substring( 0, 4) );
        
        jahr= geburts.getaktuellesDatum();
        aktjahr= new Integer(jahr.substring( 0, 4) );
        alter= aktjahr.intValue()- gebjahr.intValue();
        
        if (geburts.zwischenJahrestag_aktuellesDatum( stichtag))
        {
           System.out.println(anrede + " " + vorname + " " + nachname + " geboren am "
               + geburts.getdatum() + " hat nach dem letzten Programmstart Geburtstag gehabt.");
           System.out.println( 
               "Bitte nachtrglich zum " + alter + ". gratulieren.");
           System.out.println();
        }
        else
        {
            if (geburts.gleicherJahrestagwieaktuellesDatum())
            {
                System.out.println(anrede + " " + vorname + " " + nachname + " geboren am "
                    + geburts.getdatum() + " hat heute Geburtstag.");
                System.out.println( 
                    "Bitte zum " + alter + ". gratulieren.");
                System.out.println();
            }
        }
    }
   
    //Klassenmethode erzeugt neue Elemente, die am Ende der Root
    //angehngt werden
    public void erfasseElemente(Document doc, Node root ) {
        Datum dummy= new Datum();
        String eingabe;
        Element elemperson= doc.createElement("Person");
        Element elem1, elem2;
        
        System.out.println("Bitte geben Sie die hinzuzufgenden Personendaten ein !");
        
        eingabe= KonsoleEingabe("Nachname" );
        //Element erzeugen
        elem1= doc.createElement("Nachname" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        
        eingabe= KonsoleEingabe("Geburtsname" );
        if (0 != eingabe.length() ) {
            //Element erzeugen
            elem2= doc.createElement("Geburtsname" );
            elem2.appendChild(doc.createTextNode(eingabe ) );
        
            //Element Geburtsname unter Nachname hngen
            elem1.appendChild(elem2 );
        }
        
        //Element Nachname unter Person hngen
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Vorname" );
        //Element erzeugen
        elem1= doc.createElement("Vorname" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Geburtsdatum im Format yyyy.mm.dd" );
        //Element erzeugen
        elem1= doc.createElement("Geburtsdatum" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Hochzeitstag im Format yyyy.mm.dd" );
        //Element erzeugen
        elem1= doc.createElement("Hochzeitstag" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Geschlecht" );
        //Element erzeugen
        elem1= doc.createElement("Geschlecht" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Kundenart" );
        //Element erzeugen
        elem1= doc.createElement("Kundenart" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Familienstand" );
        //Element erzeugen
        elem1= doc.createElement("Familienstand" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Postleitzahl" );
        //Element erzeugen
        elem1= doc.createElement("Postleitzahl" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Ort" );
        //Element erzeugen
        elem1= doc.createElement("Ort" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        eingabe= KonsoleEingabe("Strasse" );
        //Element erzeugen
        elem1= doc.createElement("Strasse" );
        elem1.appendChild(doc.createTextNode(eingabe ) );
        elemperson.appendChild(elem1 );
        
        //nderungsdatum als Attribut von Person hinterlegen
        elemperson.setAttribute("geaendert", dummy.getaktuellesDatum() );
        
        //Element Person unter Root hngen
        root.appendChild(elemperson );
    }
    
    //Klassenmethode liest String von Standardkonsole ein und gibt diesen zurck
    public String KonsoleEingabe(String text) {
        String eingabe= "";
        
        //Inputstream zu Konsole
        //class BufferedReader in Package java.io
        //class InputStreamReader in Package java.io
        BufferedReader console= new BufferedReader(new InputStreamReader(System.in ) );
        
        System.out.print("Bitte Daten fr Element " + text + " eingeben: ");
        try {
            eingabe= console.readLine();
          //class IOException in Package java.io
        } catch (IOException e) {
            e.printStackTrace(System.err); }
            
        return eingabe;
    }
    
    //Klassenmethode durchliest rekursiv alle Knoten eines Dokumentes
    //Ausgabe jeweils von NodeType, NodeName, NodeValue und zugehrigen Attributen
    public void XMLAusgabe(Node node) {
        System.out.println("NodeName=" + node.getNodeName() );
        System.out.print("NodeType=" + node.getNodeType() + ": " );
        //Verarbeitung aller Knotentypen
        switch (node.getNodeType() ) {
            case Node.DOCUMENT_NODE:
                System.out.println("DOCUMENT_NODE" );
                
                //alle Kinder Rekursiv weiterverarbeiten
                NodeList nodes = node.getChildNodes();
                if (nodes != null) {
                    for (int i=0; i<nodes.getLength(); i++) {
                        XMLAusgabe(nodes.item(i));
                    }
                }
                break;

            case Node.DOCUMENT_TYPE_NODE:
                System.out.println("DOCUMENT_TYPE_NODE " +
                    ": Name: " + node.getNodeName() );
                    
                //Interface DocumentType in Package org.w3c.dom 
                DocumentType docType = (DocumentType)node;
                if (docType.getPublicId() != null)  {
                    System.out.println("DOCTYPE=PUBLIC " + docType.getPublicId());
                } else {
                    System.out.println("DOCTYPE=SYSTEM " + docType.getSystemId());
                }
                break;

            case Node.ELEMENT_NODE:
                System.out.println("ELEMENT_NODE " +
                    ": Name: " + node.getNodeName() +
                    " Inhalt: " + node.getNodeValue() );
                    
                //alle Atrribute ausgeben
                //Interface NamedNodeMap in Package org.w3c.dom 
                NamedNodeMap attributes = node.getAttributes();
                for (int i=0; i<attributes.getLength(); i++) {
                    Node current = attributes.item(i);
                    System.out.print("    Attribute: Name: " +
                        current.getNodeName() +
                        " Inhalt: " + current.getNodeValue() );
                }
                System.out.println();
                
                //alle Kinder Rekursiv weiterverarbeiten
                NodeList childnodes = node.getChildNodes();
                if (childnodes != null) {
                    for (int i=0; i<childnodes.getLength(); i++) {
                        XMLAusgabe(childnodes.item(i));
                    }
                }
                break;

            case Node.COMMENT_NODE:
                System.out.println("COMMENT_NODE " +
                    " Inhalt: " + node.getNodeValue() );
                break;

            case Node.TEXT_NODE:
                System.out.println("TEXT_NODE " +
                    " Inhalt: " + node.getNodeValue() );
                break;

            case Node.CDATA_SECTION_NODE:
                System.out.println("CDATA_SECTION_NODE " +
                    " Inhalt: " + node.getNodeValue() );
                break;

            case Node.PROCESSING_INSTRUCTION_NODE:
                System.out.println("PROCESSING_INSTRUCTION_NODE " +
                    ": Name: " + node.getNodeName() +
                    " Inhalt: " + node.getNodeValue() );
                break;

            case Node.ENTITY_REFERENCE_NODE:
                System.out.println("ENTITY_REFERENCE_NODE " +
                    ": Name: " + node.getNodeName() );
                break;
        }

    }
    
    //Klassenmethode speichert XML-Dokument in Datei uri ab, existiert Datei uri bereits
    //wird bestehende Datei in *.alt umbenannt
    public void speicherDocument(Document doc, String uri)  {
        try {
            //Spezifiziert Ausgabeformat des XML-Dokumentes
            OutputFormat format  = new OutputFormat( doc, "ISO-8859-1", true );
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer( stringOut, format );
            serial.asDOMSerializer();
            
            //Zerlegung des XML-Dokumentes
            serial.serialize( doc.getDocumentElement() );
            
            //XML-Dokument in Datei abspeichern
            try {
                //Name des Benutzer-Verzeichnisses ermitteln
                File homedir= new File(System.getProperty("user.dir"));
                
                //File-Objekt erzeugen
                File fneu= new File(homedir, uri);
                
                //wenn Datei *.xml bereits existiert, Dateiname abndern auf *.alt
                if (fneu.exists() ) {
                    //Ermittlung Prfix
                    int pos= uri.indexOf(".");
                    String urialt= uri.substring(0, pos);
                    urialt= urialt.concat(".alt" );
                    
                    //wenn Datei *.alt bereits existiert, diese lschen
                    File falt= new File(homedir, urialt);
                    if (falt.exists() )
                        falt.delete(); //Datei lschen
                    
                    //*.xml umbenennen auf *.alt
                    fneu.renameTo(new File(homedir, urialt) );
                }
            
                //Writer-Stream erzeugen
                PrintWriter fileout= new PrintWriter(new FileWriter(fneu));
            
                //XML-Dokument schreiben mittels Auslesen des Zeichen-Output-Stream
                fileout.write(stringOut.toString() );
                
                //Stream schlieen
                fileout.close();
            }
            catch (IOException fileerror) {
                fileerror.printStackTrace();
            }
            
        } catch ( Exception ex ) {
            ex.printStackTrace();
        }
    }
    
    
}

